{===============================================================================
                       FDA to AIFF-C audio files converter                       
                                  Version  1.0
                           [23.05.2005 -- 15.10.2005]
               Copyright (c) 2005 jTommy, E-mail: jTommy@zmail.ru                               
===============================================================================}
Program fda2aifc;

{$APPTYPE CONSOLE}

Uses
  Windows, SysUtils;

Type
  ID = array[0..3] of AnsiChar;

{== AIFF-C Types ==============================================================}
Const
  // Chunk ID's
  FORM_CHUNK_ID = 'FORM'; // Format chunk
  FVER_CHUNK_ID = 'FVER'; // Version chunk
  COMM_CHUNK_ID = 'COMM'; // Common chunk
  SSND_CHUNK_ID = 'SSND'; // Sound Data chunk
  MARK_CHUNK_ID = 'MARK'; // Marker chunk

  // General consts
  AIFC_Ver1 = $a2805140; // Version 1 of AIFF-C format
  AIFF_Type = 'AIFF';    // AIFF
  AIFC_Type = 'AIFC';    // Compressed AIFF
  AIFR_Type = 'AIFR';    // Relic AIFF
  Relic_FOURCC = 'COMP'; // Relic compression FOURCC
  AIFCExt = '.aifc';     // AIFC file extension
  CodecName        : array[0..17] of AnsiChar = #16'Relic Codec v1.6'#0;
  BeginLoopMarker  : array[0..09] of AnsiChar = #08'beg loop'#0;
  EndLoopMarker    : array[0..09] of AnsiChar = #08'end loop'#0;
  StartOffsetMarker: array[0..13] of AnsiChar = #12'start offset'#0;

  // Chunks sizes
  szAIFCChunk: cardinal = 08;
  szFORMChunk: cardinal = 04;
  szFVERChunk: cardinal = 04;
  szCOMMChunk: cardinal = 22; // Exclude "CodecName" length
  szSSNDChunk: cardinal = 10;
  szMARKChunk: cardinal = 02;
  szMarker   : cardinal = 06; // Exclude "MarkerName" length

Type
  // AIFF-C chunks 
  TAIFCChunk = packed record  // AIFC chunk header
    ChunkID  : ID;       // Chunk ID
    ChunkSize: cardinal; // Size of data of the chunk
  end;

  TFORMChunk = packed record  // FORM chunk
    FormType: ID; // Type of file: "AIFF" - AIFF File; "AIFC" - Compressed AIFF; "AIFR" - Relic AIFF
  end;

  TFVERChunk = packed record  // Format Version Chunk
    TimeStamp: cardinal; // Format version (always $a2805140)
  end;

  TCOMMChunk = packed record // The Common Chunk
    Channels    : word;        // Number of channels: 1 - mono; 2 - stereo; 4 - quadro, etc.
    SampleFrames: cardinal;    // Number of sample frames per channel
    SampleSize  : word;        // Number of bits in each sample (1..32)
    SampleRate  : extended;    // Sample frames per second
    CompressType: ID;          // Compression type ID code (for Relic Codec: "COMP")
    CompressName: ShortString; // Human-readable compression type name (for Relic Codec: "Relic Codec v1.6#0")
  end;

  TSSNDChunk = packed record // The Sound Data Chunk
    Offset      : cardinal; // Data offset (Set it to zero)
    BlockSize   : cardinal; // Block size (Set it to zero)
    BlockBitrate: word;     // Size of the Frame
  end;

  TMARKChunk = packed record // The Marker Chunk
    NumMarkers: word; // Number of markers
  end;

  TAIFCMarker = packed record // The Marker structure
    MarkerId  : word;        // Uniquely ID of the marker (positive, non-zero)
    Position  : integer;     // Position in the sound data
    MarkerName: ShortString; // Name of the marker
  end;

{== FDA Types =================================================================}
Const
  // Types of the FDA chunks
  FDA_DATA = 'DATA'; // Data chunk
  FDA_FOLD = 'FOLD'; // Container chunk

  // FDA chunk ID's
  RELIC_FILE_ID = 'Relic Chunky'; // ID of the Relic file
  FBIF_CHUNK_ID = 'FBIF'; // File Burn Info chunk
  FDA_CHUNK_ID  = 'FDA '; // FDA Folder chunk
  INFO_CHUNK_ID = 'INFO'; // Information chunk
  DATA_CHUNK_ID = 'DATA'; // Data chunk

  // Chunks sizes
  szHEADChunk: cardinal = 24;
  szFDAChunk : cardinal = 20; // Exclude "ChunkName" length
  szFBIFChunk: cardinal = 00;
  szFDA_Chunk: cardinal = 00;
  szINFOChunk: cardinal = 28; // Exclude "CodecName" length
  szDATAChunk: cardinal = 04;

  _Bitrate: Extended = 86.1328125;

Type
  // FDA Chunks
  TFDAHeader = packed record // FDA file header
    Signature: array[0..11] of AnsiChar; // Relic file ID (always "Relic Chunky")
    SignServ : array[0..3] of byte;      // (always 0x0d0a1a00)
    MajorVer : cardinal; // ??? (always 0x01)
    MinorVer : cardinal; // ??? (always 0x01)
  end;

  TFDAChunk = packed record // FDA Chunk Header
    ChunkType   : ID;       // Chunk type: "DATA" - Data chunk; "FOLD" - Container chunk
    ChunkID     : ID;       // Chunk ID
    ChunkVer    : cardinal; // Chunk version
    ChunkSize   : cardinal; // Size of data of the chunk
    lenChunkName: cardinal; // Length of ChunkName
    ChunkName   : array of AnsiChar; // Name of the chunk
  end;

  TFBIFChunk = packed record // File Burn Info chunk
    lenPluginName: cardinal;          // Length of PluginName
    PluginName   : array of AnsiChar; // Name of the plugin
    PluginVer    : cardinal;          // Plugin version
    lenUserName  : cardinal;          // Length of UserName
    UserName     : array of AnsiChar; // User name in the OS
    lenBurnTime  : cardinal;          // Length of BurnTime string
    BurnTime     : array of AnsiChar; // Burn time
  end;

  TFDA_Chunk = packed record // FDA Folder chunk
  end;

  TINFOChunk = packed record // Info chunk
    Channels     : cardinal; // Number of channels (Mono - 1, Stereo - 2, etc.)
    SampleSize   : cardinal; // Sample size in bits
    BlockBitrate : cardinal; // Size of the frame (256 - 22.05kbps/ch; 512 - 44.1kbps/ch; 1024 - 88.2kbps/ch; 2048 - 176.4kbps/ch)
    SampleRate   : cardinal; // Samples per second, in hertz
    BeginLoop    : cardinal; // Position of begin loop (always 0x00)
    EndLoop      : cardinal; // Position of end loop (always 0xFFFFFFFF)
    StartOffset  : cardinal; // Start offset of loop (always 0x00)
  end;

  TDATAChunk = packed record // Data chunk 
    DataSize: cardinal; // Size of sound data
  end;

{== Utility functions =========================================================}
Function SwapNumber(ANumber: SmallInt): SmallInt; overload;
Type TArray = array[0..1] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[1]; pArray^[1]:=b;
  Result:=SmallInt(pArray^);
end;

Function SwapNumber(ANumber: word): word; overload;
Type TArray = array[0..1] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[1]; pArray^[1]:=b;
  Result:=Word(pArray^);
end;

Function SwapNumber(ANumber: integer): integer; overload;
Type TArray = array[0..3] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[3]; pArray^[3]:=b;
  b:=pArray^[1]; pArray^[1]:=pArray^[2]; pArray^[2]:=b;
  Result:=Integer(pArray^);
end;

Function SwapNumber(ANumber: cardinal): cardinal; overload;
Type TArray = array[0..3] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[3]; pArray^[3]:=b;
  b:=pArray^[1]; pArray^[1]:=pArray^[2]; pArray^[2]:=b;
  Result:=Cardinal(pArray^);
end;

Function SwapNumber(ANumber: int64): int64; overload;
Type TArray = array[0..7] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[7]; pArray^[7]:=b;
  b:=pArray^[1]; pArray^[1]:=pArray^[6]; pArray^[6]:=b;
  b:=pArray^[2]; pArray^[2]:=pArray^[5]; pArray^[5]:=b;
  b:=pArray^[3]; pArray^[3]:=pArray^[4]; pArray^[4]:=b;
  Result:=Int64(pArray^);
end;

Function SwapNumberE(ANumber: Extended): Extended;
Type TArray = array[0..9] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[9]; pArray^[9]:=b;
  b:=pArray^[1]; pArray^[1]:=pArray^[8]; pArray^[8]:=b;
  b:=pArray^[2]; pArray^[2]:=pArray^[7]; pArray^[7]:=b;
  b:=pArray^[3]; pArray^[3]:=pArray^[6]; pArray^[6]:=b;
  b:=pArray^[4]; pArray^[4]:=pArray^[5]; pArray^[5]:=b;
  Result:=Extended(pArray^);
end;

Procedure ReadChunkHeader(hFile, AChunkSize: cardinal; Var AChunk: TFDAChunk);
Var ReadCnt: cardinal;
begin
  ReadFile(hFile, AChunk, AChunkSize, ReadCnt, nil);
  if AChunk.lenChunkName<>0 then begin
    SetLength(AChunk.ChunkName, AChunk.lenChunkName);
    ReadFile(hFile, Pointer(AChunk.ChunkName)^, AChunk.lenChunkName, ReadCnt, nil);
  end;
end;

Var
  // AIFF-C Chunks
  AIFCChunk : TAIFCChunk;
  FORMChunk : TFORMChunk;
  FVERChunk : TFVERChunk;
  COMMChunk : TCOMMChunk;
  SSNDChunk : TSSNDChunk;
  MARKChunk : TMARKChunk;
  AIFCMarker: TAIFCMarker;

  // FDA Chunks
  FDAHeader: TFDAHeader;
  FDAChunk : TFDAChunk;
  FBIFChunk: TFBIFChunk;
  INFOChunk: TINFOChunk;
  DATAChunk: TDATAChunk;

  // Other vars
  hFind, hFDA, hAIFC, RdC, WrC: cardinal;
  NumFiles, n: integer;
  SoundData: pointer;
  FDAFiles: array of string;
  FindData: TWin32FindData;

begin
  WriteLn('FDA to AIFC converter v1.0 by jTommy [jTommy@zmail.ru]');
  if ParamCount=0 then begin
    WriteLn('Usage: fda2aifc.exe [filename.fda or filemask]');
    Exit;
  end;
  // Find FDA files
  NumFiles:=0;
  hFind:=FindFirstFile(PChar(ParamStr(1)), FindData);
  if hFind<>INVALID_HANDLE_VALUE then begin
    repeat       
      if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY)=0 then begin
        inc(NumFiles);
        SetLength(FDAFiles, NumFiles);
        FDAFiles[NumFiles-1]:=FindData.cFileName;
      end;
    until not FindNextFile(hFind, FindData);
    Windows.FindClose(hFind);
  end;
  WriteLn('Find ', NumFiles, ' files');
  for n:=0 to NumFiles-1 do begin
    Write(Format('[%d/%d] %s ', [n+1, NumFiles, ExtractFileName(FDAFiles[n])]));
    {== Read FDA file =========================================================}
    // Open FDA file
    hFDA:=CreateFile(PChar(FDAFiles[n]), GENERIC_READ, FILE_SHARE_READ, nil, OPEN_EXISTING, 0, 0);
    if hFDA=INVALID_HANDLE_VALUE then begin
      WriteLn('Error open file.');
      Continue;
    end;
    // Read FDA Header
    ReadFile(hFDA, FDAHeader, szHEADChunk, RdC, nil);
    if FDAHeader.Signature<>RELIC_FILE_ID then begin
      WriteLn('File not Relic Chunky.');
      CloseHandle(hFDA);
      Continue;
    end;
    // Read FBIF chunk
    ReadChunkHeader(hFDA, szFDAChunk, FDAChunk);
    if FDAChunk.ChunkID<>FBIF_CHUNK_ID then begin
      WriteLn('Not found FBIF chunk.');
      CloseHandle(hFDA);
      Continue;
    end;
    //
    ReadFile(hFDA, FBIFChunk.lenPluginName, SizeOf(FBIFChunk.lenPluginName), RdC, nil);
    SetLength(FBIFChunk.PluginName, FBIFChunk.lenPluginName);
    ReadFile(hFDA, Pointer(FBIFChunk.PluginName)^, FBIFChunk.lenPluginName, RdC, nil);
    ReadFile(hFDA, FBIFChunk.PluginVer, SizeOf(FBIFChunk.PluginVer), RdC, nil);
    //
    ReadFile(hFDA, FBIFChunk.lenUserName, SizeOf(FBIFChunk.lenUserName), RdC, nil);
    SetLength(FBIFChunk.UserName, FBIFChunk.lenUserName);
    ReadFile(hFDA, Pointer(FBIFChunk.UserName)^, FBIFChunk.lenUserName, RdC, nil);
    //
    ReadFile(hFDA, FBIFChunk.lenBurnTime, SizeOf(FBIFChunk.lenBurnTime), RdC, nil);
    SetLength(FBIFChunk.BurnTime, FBIFChunk.lenBurnTime);
    ReadFile(hFDA, Pointer(FBIFChunk.BurnTime)^, FBIFChunk.lenBurnTime, RdC, nil);
    // Read FDA_ chunk
    ReadChunkHeader(hFDA, szFDAChunk, FDAChunk);
    if FDAChunk.ChunkID<>FDA_CHUNK_ID then begin
      WriteLn('File not FDA.');
      CloseHandle(hFDA);
      Continue;
    end;
    // Read INFO chunk
    ReadChunkHeader(hFDA, szFDAChunk, FDAChunk);
    if FDAChunk.ChunkID<>INFO_CHUNK_ID then begin
      WriteLn('Not found INFO chunk.');
      CloseHandle(hFDA);
      Continue;
    end;
    ReadFile(hFDA, INFOChunk, szINFOChunk, RdC, nil);
    // Read DATA chunk
    ReadChunkHeader(hFDA, szFDAChunk, FDAChunk);
    if FDAChunk.ChunkID<>DATA_CHUNK_ID then begin
      WriteLn('Not found DATA chunk.');
      CloseHandle(hFDA);
      Continue;
    end;
    ReadFile(hFDA, DATAChunk, szDATAChunk, RdC, nil);
    // Show info
    Write(Format('(%.1fkbps, %.1fkHz, %dch)...',
      [(INFOChunk.BlockBitrate * _Bitrate * INFOChunk.Channels) / 1000,
      INFOChunk.SampleRate / 1000, INFOChunk.Channels]));
    {== Create AIFF-C file ====================================================}
    hAIFC:=CreateFile(PChar(ChangeFileExt(FDAFiles[n], AIFCExt)), GENERIC_WRITE, FILE_SHARE_READ, nil,
                      CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
    if hAIFC=INVALID_HANDLE_VALUE then begin
      WriteLn('Error create file.');
      CloseHandle(hFDA);
      Continue;
    end;
    // Write FORM chunk
    AIFCChunk.ChunkID:=FORM_CHUNK_ID;
    AIFCChunk.ChunkSize:=0;
    FORMChunk.FormType:=AIFC_Type;
    WriteFile(hAIFC, AIFCChunk, szAIFCChunk, WrC, nil);
    WriteFile(hAIFC, FORMChunk, szFORMChunk, WrC, nil);
    // Write FVER chunk
    AIFCChunk.ChunkID:=FVER_CHUNK_ID;
    AIFCChunk.ChunkSize:=SwapNumber(szFVERChunk);
    FVERChunk.TimeStamp:=SwapNumber(AIFC_Ver1);
    WriteFile(hAIFC, AIFCChunk, szAIFCChunk, WrC, nil);
    WriteFile(hAIFC, FVERChunk, szFVERChunk, WrC, nil);
    // Write COMM chunk
    AIFCChunk.ChunkID:=COMM_CHUNK_ID;
    AIFCChunk.ChunkSize:=SwapNumber(szCOMMChunk+Cardinal(Length(CodecName))-1);
    COMMChunk.Channels:=SwapNumber(Word(INFOChunk.Channels));
    COMMChunk.SampleFrames:=SwapNumber(DATAChunk.DataSize div ((INFOChunk.BlockBitrate div 8)*
                                       INFOChunk.Channels));
    COMMChunk.SampleSize:=SwapNumber(Word(INFOChunk.SampleSize));
    COMMChunk.SampleRate:=SwapNumberE(INFOChunk.SampleRate);
    COMMChunk.CompressType:=Relic_FOURCC;
    WriteFile(hAIFC, AIFCChunk, szAIFCChunk, WrC, nil);
    WriteFile(hAIFC, COMMChunk, szCOMMChunk, WrC, nil);
    WriteFile(hAIFC, CodecName, Length(CodecName), WrC, nil);
    // Write SSND chunk
    AIFCChunk.ChunkID:=SSND_CHUNK_ID;
    AIFCChunk.ChunkSize:=SwapNumber(szSSNDChunk+DATAChunk.DataSize);
    SSNDChunk.Offset:=0;
    SSNDChunk.BlockSize:=0;
    SSNDChunk.BlockBitrate:=SwapNumber(Word(INFOChunk.BlockBitrate));
    WriteFile(hAIFC, AIFCChunk, szAIFCChunk, WrC, nil);
    WriteFile(hAIFC, SSNDChunk, szSSNDChunk, WrC, nil);
    // Read & write sound data
    SoundData:=AllocMem(DATAChunk.DataSize);
    ReadFile(hFDA, SoundData^, DATAChunk.DataSize, RdC, nil);
    WriteFile(hAIFC, SoundData^, DATAChunk.DataSize, WrC, nil);
    FreeMem(SoundData, DATAChunk.DataSize);
    // Write MARK chunk
    AIFCChunk.ChunkID:=MARK_CHUNK_ID;
    AIFCChunk.ChunkSize:=SwapNumber(Cardinal(54));
    MARKChunk.NumMarkers:=SwapNumber(Word(3));
    WriteFile(hAIFC, AIFCChunk, szAIFCChunk, WrC, nil);
    WriteFile(hAIFC, MARKChunk, szMARKChunk, WrC, nil);
    // Write Markers. Marker 1 "Begin loop"
    AIFCMarker.MarkerId:=SwapNumber(Word(1));
    AIFCMarker.Position:=SwapNumber(INFOChunk.BeginLoop);
    WriteFile(hAIFC, AIFCMarker, szMarker, WrC, nil);
    WriteFile(hAIFC, BeginLoopMarker, Length(BeginLoopMarker), WrC, nil);
    // Marker 2 "End loop"
    AIFCMarker.MarkerId:=SwapNumber(Word(2));
    AIFCMarker.Position:=SwapNumber(INFOChunk.EndLoop);
    WriteFile(hAIFC, AIFCMarker, szMarker, WrC, nil);
    WriteFile(hAIFC, EndLoopMarker, Length(EndLoopMarker), WrC, nil);
    // Marker 3 "Start offset"
    AIFCMarker.MarkerId:=SwapNumber(Word(3));
    AIFCMarker.Position:=SwapNumber(INFOChunk.StartOffset);
    WriteFile(hAIFC, AIFCMarker, szMarker, WrC, nil);
    WriteFile(hAIFC, StartOffsetMarker, Length(StartOffsetMarker), WrC, nil);
    // Write size of the FORM chunk
    SetFilePointer(hAIFC, 0, nil, FILE_BEGIN);
    AIFCChunk.ChunkID:=FORM_CHUNK_ID;
    AIFCChunk.ChunkSize:=SwapNumber(GetFileSize(hAIFC, nil)-8);
    WriteFile(hAIFC, AIFCChunk, szAIFCChunk, WrC, nil);
    // Close files
    CloseHandle(hFDA);
    CloseHandle(hAIFC);
    WriteLn('done');
  end;
end.
