Program decShell;

{$APPTYPE CONSOLE}

Uses
  Windows, SysUtils;

Var
  hFind, hConsole: cardinal;
  NumFiles, n: integer;
  FindData: TWin32FindData;
  Files: array of string;

Function ExecuteAndWait(Const Path: string): boolean;
Var
 PInfo: TProcessInformation;
 SInfo: TStartupInfo;
begin
  Result:=False;
  ZeroMemory(@SInfo, SizeOf(SInfo));
  SInfo.cb:=SizeOf(SInfo);
  if CreateProcess(nil, PChar(Path), nil, nil, False, 0, nil, nil, SInfo, PInfo) then begin
    Result:=True;
    WaitForSingleObject(PInfo.hProcess, INFINITE);
    CloseHandle(PInfo.hProcess);
    CloseHandle(PInfo.hThread);
  end;
end;

begin
  WriteLn('Shell for Relic AIFR decoder (Homeworld II AIFR => WAV PCM) [dec.exe]');
  if ParamCount=0 then begin
    WriteLn('Usage: decShell <AIFR file or filemask>');
    Exit;
  end;
  // Find files
  NumFiles:=0;
  hFind:=FindFirstFile(PChar(ParamStr(1)), FindData);
  if hFind<>INVALID_HANDLE_VALUE then begin
    repeat
      if (FindData.dwFileAttributes and FILE_ATTRIBUTE_ARCHIVE)<>0 then begin
        inc(NumFiles);
        SetLength(Files, NumFiles);
        Files[NumFiles-1]:=FindData.cFileName;
      end;
    until not FindNextFile(hFind, FindData);
    Windows.FindClose(hFind);
  end;
  // Execute
  hConsole:=GetStdHandle(STD_OUTPUT_HANDLE);
  for n:=0 to NumFiles-1 do begin
    SetConsoleTextAttribute(hConsole, 14+0*16);
    WriteLn(#13#10'[',n+1,' of ',NumFiles,'] decoding...');
    SetConsoleTextAttribute(hConsole, 7+0*16);
    ExecuteAndWait('dec.exe "'+Files[n]+'" "'+ChangeFileExt(Files[n], '.wav')+'"');
  end;
  SetConsoleTextAttribute(hConsole, 7+0*16);
end.
