{===============================================================================
                       AIFF-C to FDA audio files converter                       
                                  Version  1.0
                           [02.11.2005 -- 03.11.2005]
               Copyright (c) 2005 jTommy, E-mail: jTommy@zmail.ru                             
===============================================================================}
Program aifc2fda;

{$APPTYPE CONSOLE}

Uses
  Windows, SysUtils;

Type
  ID = array[0..3] of AnsiChar;

{== AIFF-C Types ==============================================================}
Const
  // Chunk ID's
  FORM_CHUNK_ID = 'FORM'; // Format chunk
  FVER_CHUNK_ID = 'FVER'; // Version chunk
  COMM_CHUNK_ID = 'COMM'; // Common chunk
  SSND_CHUNK_ID = 'SSND'; // Sound Data chunk
  MARK_CHUNK_ID = 'MARK'; // Marker chunk

  // General consts
  AIFC_Ver1 = $a2805140; // Version 1 of AIFF-C format
  AIFF_Type = 'AIFF';    // AIFF
  AIFC_Type = 'AIFC';    // Compressed AIFF
  AIFR_Type = 'AIFR';    // Relic AIFF
  Relic_FOURCC = 'COMP'; // Relic compression FOURCC
  FDAExt = '.fda';       // FDA file extension
  CodecName        : array[0..17] of AnsiChar = #16'Relic Codec v1.6'#0;
  BeginLoopMarker  : array[0..09] of AnsiChar = #08'beg loop'#0;
  EndLoopMarker    : array[0..09] of AnsiChar = #08'end loop'#0;
  StartOffsetMarker: array[0..13] of AnsiChar = #12'start offset'#0;

  // Chunks sizes
  szAIFCChunk: cardinal = 08;
  szFORMChunk: cardinal = 04;
  szFVERChunk: cardinal = 04;
  szCOMMChunk: cardinal = 22; // Exclude "CodecName" length
  szSSNDChunk: cardinal = 10;
  szMARKChunk: cardinal = 02;
  szMarker   : cardinal = 06; // Exclude "MarkerName" length

Type
  // AIFF-C chunks 
  TAIFCChunk = packed record  // AIFC chunk header
    ChunkID  : ID;       // Chunk ID
    ChunkSize: cardinal; // Size of data of the chunk
  end;

  TFORMChunk = packed record  // FORM chunk
    FormType: ID; // Type of file: "AIFF" - AIFF File; "AIFC" - Compressed AIFF; "AIFR" - Relic AIFF
  end;

  TFVERChunk = packed record  // Format Version Chunk
    TimeStamp: cardinal; // Format version (always $a2805140)
  end;

  TCOMMChunk = packed record // The Common Chunk
    Channels    : word;        // Number of channels: 1 - mono; 2 - stereo; 4 - quadro, etc.
    SampleFrames: cardinal;    // Number of sample frames per channel
    SampleSize  : word;        // Number of bits in each sample (1..32)
    SampleRate  : extended;    // Sample frames per second
    CompressType: ID;          // Compression type ID code (for Relic Codec: "COMP")
    CompressName: ShortString; // Human-readable compression type name (for Relic Codec: "Relic Codec v1.6#0")
  end;

  TSSNDChunk = packed record // The Sound Data Chunk
    Offset      : cardinal; // Data offset (Set it to zero)
    BlockSize   : cardinal; // Block size (Set it to zero)
    BlockBitrate: word;     // Size of the Frame
  end;

  TMARKChunk = packed record // The Marker Chunk
    NumMarkers: word; // Number of markers
  end;

  TAIFCMarker = packed record // The Marker structure
    MarkerId  : word;        // Uniquely ID of the marker (positive, non-zero)
    Position  : integer;     // Position in the sound data
    MarkerName: ShortString; // Name of the marker
  end;

{== FDA Types =================================================================}
Const
  // Types of the FDA chunks
  FDA_DATA = 'DATA'; // Data chunk
  FDA_FOLD = 'FOLD'; // Container chunk

  // FDA chunk ID's
  RELIC_FILE_ID = 'Relic Chunky'; // ID of the Relic file
  SIGN_SERV_ID  = $001a0a0d;      // Service signature
  FBIF_CHUNK_ID = 'FBIF'; // File Burn Info chunk
  FDA_CHUNK_ID  = 'FDA '; // FDA Folder chunk
  INFO_CHUNK_ID = 'INFO'; // Information chunk
  DATA_CHUNK_ID = 'DATA'; // Data chunk

  // Chunks sizes
  szHEADChunk: cardinal = 24;
  szFDAChunk : cardinal = 20; // Exclude "ChunkName" length
  szFBIFChunk: cardinal = 16; // Exclude strings length
  szFDA_Chunk: cardinal = 00;
  szINFOChunk: cardinal = 28; 
  szDATAChunk: cardinal = 04;

  _Bitrate: Extended = 86.1328125;

Type
  // FDA Chunks
  TFDAHeader = packed record // FDA file header
    Signature: array[0..11] of AnsiChar; // Relic file ID (always "Relic Chunky")
    SignServ : cardinal; // (always 0x0d0a1a00)
    MajorVer : cardinal; // ??? (always 0x01)
    MinorVer : cardinal; // ??? (always 0x01)
  end;

  TFDAChunk = packed record // FDA Chunk Header
    ChunkType   : ID;       // Chunk type: "DATA" - Data chunk; "FOLD" - Container chunk
    ChunkID     : ID;       // Chunk ID
    ChunkVer    : cardinal; // Chunk version
    ChunkSize   : cardinal; // Size of data of the chunk
    lenChunkName: cardinal; // Length of ChunkName
    ChunkName   : array of AnsiChar; // Name of the chunk
  end;

  TFBIFChunk = packed record // File Burn Info chunk
    lenPluginName: cardinal;          // Length of PluginName
    PluginName   : array of AnsiChar; // Name of the plugin
    PluginVer    : cardinal;          // Plugin version
    lenUserName  : cardinal;          // Length of UserName
    UserName     : array of AnsiChar; // User name in the OS
    lenBurnTime  : cardinal;          // Length of BurnTime string
    BurnTime     : array of AnsiChar; // Burn time
  end;

  TFDA_Chunk = packed record // FDA Folder chunk
  end;

  TINFOChunk = packed record // Info chunk
    Channels     : cardinal; // Number of channels (Mono - 1, Stereo - 2, etc.)
    SampleSize   : cardinal; // Sample size in bits
    BlockBitrate : cardinal; // Size of the frame (256 - 22.05kbps/ch; 512 - 44.1kbps/ch; 1024 - 88.2kbps/ch; 2048 - 176.4kbps/ch)
    SampleRate   : cardinal; // Samples per second, in hertz
    BeginLoop    : cardinal; // Position of begin loop (always 0x00)
    EndLoop      : cardinal; // Position of end loop (always 0xFFFFFFFF)
    StartOffset  : cardinal; // Start offset of loop (always 0x00)
  end;

  TDATAChunk = packed record // Data chunk 
    DataSize: cardinal; // Size of sound data
  end;

{== Utility functions =========================================================}
Function SwapNumber(ANumber: SmallInt): SmallInt; overload;
Type TArray = array[0..1] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[1]; pArray^[1]:=b;
  Result:=SmallInt(pArray^);
end;

Function SwapNumber(ANumber: word): word; overload;
Type TArray = array[0..1] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[1]; pArray^[1]:=b;
  Result:=Word(pArray^);
end;

Function SwapNumber(ANumber: integer): integer; overload;
Type TArray = array[0..3] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[3]; pArray^[3]:=b;
  b:=pArray^[1]; pArray^[1]:=pArray^[2]; pArray^[2]:=b;
  Result:=Integer(pArray^);
end;

Function SwapNumber(ANumber: cardinal): cardinal; overload;
Type TArray = array[0..3] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[3]; pArray^[3]:=b;
  b:=pArray^[1]; pArray^[1]:=pArray^[2]; pArray^[2]:=b;
  Result:=Cardinal(pArray^);
end;

Function SwapNumber(ANumber: int64): int64; overload;
Type TArray = array[0..7] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[7]; pArray^[7]:=b;
  b:=pArray^[1]; pArray^[1]:=pArray^[6]; pArray^[6]:=b;
  b:=pArray^[2]; pArray^[2]:=pArray^[5]; pArray^[5]:=b;
  b:=pArray^[3]; pArray^[3]:=pArray^[4]; pArray^[4]:=b;
  Result:=Int64(pArray^);
end;

Function SwapNumberE(ANumber: Extended): Extended;
Type TArray = array[0..9] of byte;
Var pArray: ^TArray;
    b: byte;
begin
  pArray:=@ANumber;
  b:=pArray^[0]; pArray^[0]:=pArray^[9]; pArray^[9]:=b;
  b:=pArray^[1]; pArray^[1]:=pArray^[8]; pArray^[8]:=b;
  b:=pArray^[2]; pArray^[2]:=pArray^[7]; pArray^[7]:=b;
  b:=pArray^[3]; pArray^[3]:=pArray^[6]; pArray^[6]:=b;
  b:=pArray^[4]; pArray^[4]:=pArray^[5]; pArray^[5]:=b;
  Result:=Extended(pArray^);
end;

Var
  // AIFF-C Chunks
  AIFCChunk : TAIFCChunk;
  FORMChunk : TFORMChunk;
  FVERChunk : TFVERChunk;
  COMMChunk : TCOMMChunk;
  SSNDChunk : TSSNDChunk;
//  MARKChunk : TMARKChunk;
//  AIFCMarker: TAIFCMarker;

  // FDA Chunks
  FDAHeader: TFDAHeader;
  FDAChunk : TFDAChunk;
  FBIFChunk: TFBIFChunk;
  INFOChunk: TINFOChunk;
  DATAChunk: TDATAChunk;

  // Other vars
  hFind, hFDA, hAIFC, RdC, WrC: cardinal;
  NumFiles, n: integer;
  SoundData: pointer;
  Files: array of string;
  FindData: TWin32FindData;
  _st: string;

begin
  WriteLn('AIFC to FDA converter v1.0 by jTommy [jTommy@zmail.ru]');
  if ParamCount=0 then begin
    WriteLn('Usage: aifc2fda.exe [filename.aifc or filemask]');
    Exit;
  end;
  // Find AIFC files
  NumFiles:=0;
  hFind:=FindFirstFile(PChar(ParamStr(1)), FindData);
  if hFind<>INVALID_HANDLE_VALUE then begin
    repeat       
      if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY)=0 then begin
        inc(NumFiles);
        SetLength(Files, NumFiles);
        Files[NumFiles-1]:=FindData.cFileName;
      end;
    until not FindNextFile(hFind, FindData);
    Windows.FindClose(hFind);
  end;
  WriteLn('Find ', NumFiles, ' files');
  for n:=0 to NumFiles-1 do begin
    Write(Format('[%d/%d] %s ', [n+1, NumFiles, ExtractFileName(Files[n])]));
    {== Open AIFF-C file ====================================================}
    hAIFC:=CreateFile(PChar(Files[n]), GENERIC_READ, FILE_SHARE_READ, nil, OPEN_EXISTING, 0, 0);
    if hAIFC=INVALID_HANDLE_VALUE then begin
      WriteLn('Error open file.');
      Continue;
    end;
    // Read FORM chunk
    ReadFile(hAIFC, AIFCChunk, szAIFCChunk, RdC, nil);
    ReadFile(hAIFC, FORMChunk, szFORMChunk, RdC, nil);
    if (AIFCChunk.ChunkID<>FORM_CHUNK_ID) or ((FORMChunk.FormType<>AIFC_Type) and (FORMChunk.FormType<>AIFR_Type)) then begin
      WriteLn('Unknown file format.');
      CloseHandle(hAIFC);
      Continue;
    end;
    // Read FVER chunk
    ReadFile(hAIFC, AIFCChunk, szAIFCChunk, RdC, nil);
    ReadFile(hAIFC, FVERChunk, szFVERChunk, RdC, nil);
    // Read COMM chunk
    ReadFile(hAIFC, AIFCChunk, szAIFCChunk, RdC, nil);
    ReadFile(hAIFC, COMMChunk, szCOMMChunk, RdC, nil);
    COMMChunk.Channels:=SwapNumber(COMMChunk.Channels);
    COMMChunk.SampleFrames:=SwapNumber(COMMChunk.SampleFrames);
    COMMChunk.SampleSize:=SwapNumber(COMMChunk.SampleSize);
    COMMChunk.SampleRate:=SwapNumberE(COMMChunk.SampleRate);
    ReadFile(hAIFC, COMMChunk.CompressName, SwapNumber(AIFCChunk.ChunkSize)-szCOMMChunk+1, RdC, nil);
    // Read SSND chunk
    ReadFile(hAIFC, AIFCChunk, szAIFCChunk, RdC, nil);
    AIFCChunk.ChunkSize:=SwapNumber(AIFCChunk.ChunkSize)-szSSNDChunk;
    ReadFile(hAIFC, SSNDChunk, szSSNDChunk, RdC, nil);
    SSNDChunk.BlockBitrate:=SwapNumber(SSNDChunk.BlockBitrate);
    // Show info
    Write(Format('(%.1fkbps, %.1fkHz, %dch)...',
      [(SSNDChunk.BlockBitrate * _Bitrate * COMMChunk.Channels) / 1000,
      COMMChunk.SampleRate / 1000, COMMChunk.Channels]));
    {== Write FDA file =========================================================}
    // Create FDA file
    hFDA:=CreateFile(PChar(ChangeFileExt(Files[n], FDAExt)), GENERIC_WRITE, FILE_SHARE_READ, nil,
                     CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
    if hAIFC=INVALID_HANDLE_VALUE then begin
      WriteLn('Error create file.');
      CloseHandle(hFDA);
      Continue;
    end;
    // Write FDA Header
    FDAHeader.Signature:=RELIC_FILE_ID;
    FDAHeader.SignServ:=SIGN_SERV_ID;
    FDAHeader.MajorVer:=1;
    FDAHeader.MinorVer:=1;
    WriteFile(hFDA, FDAHeader, szHEADChunk, WrC, nil);
    // Write FBIF chunk
    FDAChunk.ChunkType:=FDA_DATA;
    FDAChunk.ChunkID:=FBIF_CHUNK_ID;
    FDAChunk.ChunkVer:=1;
    _st:='FileBurnInfo'#0;
    FDAChunk.ChunkName:=Pointer(_st);
    FDAChunk.lenChunkName:=Length(FDAChunk.ChunkName);
    _st:='RAW to FDA';
    FBIFChunk.PluginName:=Pointer(_st);;
    FBIFChunk.lenPluginName:=Length(FBIFChunk.PluginName);
    FBIFChunk.PluginVer:=1;
    FBIFChunk.lenUserName:=200;
    SetLength(_st, FBIFChunk.lenUserName);
    if GetUserName(PChar(_st), FBIFChunk.lenUserName) then begin
      dec(FBIFChunk.lenUserName);
      SetLength(_st, FBIFChunk.lenUserName);
      FBIFChunk.UserName:=Pointer(_st);
    end else begin
      FBIFChunk.lenUserName:=0;
      FBIFChunk.UserName:=nil;
    end;
    DateTimeToString(_st, 'mmmm dd, yyyy, h:nn:ss AM/PM', Now);
    FBIFChunk.BurnTime:=Pointer(_st);
    FBIFChunk.lenBurnTime:=Length(FBIFChunk.BurnTime);
    FDAChunk.ChunkSize:=szFBIFChunk+
      FBIFChunk.lenPluginName+FBIFChunk.lenUserName+FBIFChunk.lenBurnTime;
    WriteFile(hFDA, FDAChunk, szFDAChunk, WrC, nil);
    WriteFile(hFDA, Pointer(FDAChunk.ChunkName)^, FDAChunk.lenChunkName, WrC, nil);
    WriteFile(hFDA, FBIFChunk.lenPluginName, SizeOf(FBIFChunk.lenPluginName), WrC, nil);
    WriteFile(hFDA, Pointer(FBIFChunk.PluginName)^, FBIFChunk.lenPluginName, WrC, nil);
    WriteFile(hFDA, FBIFChunk.PluginVer, SizeOf(FBIFChunk.PluginVer), WrC, nil);
    WriteFile(hFDA, FBIFChunk.lenUserName, SizeOf(FBIFChunk.lenUserName), WrC, nil);
    WriteFile(hFDA, Pointer(FBIFChunk.UserName)^, FBIFChunk.lenUserName, WrC, nil);
    WriteFile(hFDA, FBIFChunk.lenBurnTime, SizeOf(FBIFChunk.lenBurnTime), WrC, nil);
    WriteFile(hFDA, Pointer(FBIFChunk.BurnTime)^, FBIFChunk.lenBurnTime, WrC, nil);
    // Write FDA_ chunk
    FDAChunk.ChunkType:=FDA_FOLD;
    FDAChunk.ChunkID:=FDA_CHUNK_ID;
    FDAChunk.ChunkVer:=1;
    FDAChunk.ChunkSize:=2*szFDAChunk+szINFOChunk+szDATAChunk+AIFCChunk.ChunkSize;
    FDAChunk.lenChunkName:=0;
    FDAChunk.ChunkName:=nil;
    WriteFile(hFDA, FDAChunk, szFDAChunk, WrC, nil);
    // Write INFO chunk
    FDAChunk.ChunkType:=FDA_DATA;
    FDAChunk.ChunkID:=INFO_CHUNK_ID;
    FDAChunk.ChunkVer:=1;
    FDAChunk.ChunkSize:=szINFOChunk;
    FDAChunk.lenChunkName:=0;
    FDAChunk.ChunkName:=nil;
    WriteFile(hFDA, FDAChunk, szFDAChunk, WrC, nil);
    INFOChunk.Channels:=COMMChunk.Channels;
    INFOChunk.SampleSize:=COMMChunk.SampleSize;
    INFOChunk.BlockBitrate:=SSNDChunk.BlockBitrate;
    INFOChunk.SampleRate:=Round(COMMChunk.SampleRate);
    INFOChunk.BeginLoop:=0;
    INFOChunk.EndLoop:=$ffffffff;
    INFOChunk.StartOffset:=0;
    WriteFile(hFDA, INFOChunk, szINFOChunk, WrC, nil);
    // Write DATA chunk
    FDAChunk.ChunkType:=FDA_DATA;
    FDAChunk.ChunkID:=DATA_CHUNK_ID;
    FDAChunk.ChunkVer:=1;
    FDAChunk.ChunkSize:=szDATAChunk+AIFCChunk.ChunkSize;
    FDAChunk.lenChunkName:=0;
    FDAChunk.ChunkName:=nil;
    WriteFile(hFDA, FDAChunk, szFDAChunk, WrC, nil);
    DATAChunk.DataSize:=AIFCChunk.ChunkSize;
    WriteFile(hFDA, DATAChunk, szDATAChunk, WrC, nil);
    // Read & write sound data
    SoundData:=AllocMem(AIFCChunk.ChunkSize);
    ReadFile(hAIFC, SoundData^, AIFCChunk.ChunkSize, RdC, nil);
    WriteFile(hFDA, SoundData^, AIFCChunk.ChunkSize, WrC, nil);
    FreeMem(SoundData, AIFCChunk.ChunkSize);
    // Close files
    CloseHandle(hAIFC);
    CloseHandle(hFDA);
    WriteLn('done');
  end;
end.

